package com.jonohennessy {
	import flash.display.*;
	import com.adamsearle.utils.*;
	
	public class HennessyController extends MovieClip {
		
		// Declare vars - note automatically declare stage instances is disabled
		public var menuView:MovieClip;
		public var preloader_mc:MovieClip;
		private var hennessyModel:HennessyModel;
		private var musicPlayer:BackgroundMusicPlayer;
		
		// Other instances
		public var optical:OpticalView;
		public var sunwear:SunwearView;
		public var agents:AgentsView;
		public var promo:PromoView;
		public var theStory:TheStoryView;
		public var news:NewsView;
		public var contact:ContactView;
		
		// Constructor
		public function HennessyController() {
			hennessyModel = new com.jonohennessy.HennessyModel();
			
			// Set content_mode to menu, as we always start into menu
			hennessyModel.setMode(HennessyModel.CONTENT_MENU);
			
			// Set the scale mode
			this.stage.scaleMode = StageScaleMode.NO_SCALE;
			
			// Instantiate the music player with mp3 reference
			musicPlayer = new BackgroundMusicPlayer("short.mp3");
		}
		
		// Called when a menu item is clicked - we are to figure out what to load
		public function menuClicked():void {
			
			// Switch to determine what the new content to load in is
			switch (hennessyModel.getMode()) {
				
				case HennessyModel.CONTENT_OPTICAL:
					optical = new com.jonohennessy.OpticalView();
					addChildAt(optical, getChildIndex(menuView));
					break;
					
				case HennessyModel.CONTENT_SUNWEAR:
					sunwear = new com.jonohennessy.SunwearView();
					addChildAt(sunwear, getChildIndex(menuView));
					break;
					
				case HennessyModel.CONTENT_PROMO:
					promo = new com.jonohennessy.PromoView();
					addChildAt(promo, getChildIndex(menuView));
					break;
					
				case HennessyModel.CONTENT_THESTORY:
					theStory = new com.jonohennessy.TheStoryView();
					addChildAt(theStory, getChildIndex(menuView));
					break;
					
				case HennessyModel.CONTENT_NEWS:
					news = new com.jonohennessy.NewsView();
					addChildAt(news, getChildIndex(menuView));
					break;
					
				case HennessyModel.CONTENT_AGENTS:
					agents = new com.jonohennessy.AgentsView();
					addChildAt(agents, getChildIndex(menuView));
					break;
					
				case HennessyModel.CONTENT_CONTACT:
					contact = new com.jonohennessy.ContactView();
					addChildAt(contact, getChildIndex(menuView));
					break;
					
				default:
					trace("!! ----- Unknown menuReturnComplete content mode: " + hennessyModel.getMode());
			}
		}
		
		// Called when a content item returns home - we are to get the menu to come back
		public function homeClicked():void {
			trace("homeClicked was hit");
			
			// Call the menu to come back
			menuView.playReturn();
		}
		
		// Called when the menu returns in place - kill the content
		public function menuReturnComplete():void {
			trace("menuReturnComplete was hit");
			
			// Switch to determine what content was showing that must be removed
			switch (hennessyModel.getMode()) {
				
				case HennessyModel.CONTENT_OPTICAL:
					optical.dispose();
					removeChild(optical);
					break;
					
				case HennessyModel.CONTENT_SUNWEAR:
					sunwear.dispose();
					removeChild(sunwear);
					break;
					
				case HennessyModel.CONTENT_PROMO:
					promo.dispose();
					removeChild(promo);
					break;
					
				case HennessyModel.CONTENT_THESTORY:
					theStory.dispose();
					removeChild(theStory);
					break;
					
				case HennessyModel.CONTENT_NEWS:
					news.dispose();
					removeChild(news);
					break;
					
				case HennessyModel.CONTENT_AGENTS:
					agents.dispose();
					removeChild(agents);
					break;
					
				case HennessyModel.CONTENT_CONTACT:
					contact.dispose();
					removeChild(contact);
					break;
					
				default:
					trace("!! ----- Unknown menuReturnComplete content mode: " + hennessyModel.getMode());
			}
			
			// Unlock animation and set mode to menu
			hennessyModel.setAnimatingLock(false);
			hennessyModel.setMode(HennessyModel.CONTENT_MENU);
		}
		
		public function getModel():HennessyModel {
			return hennessyModel;
		}
		
		public function getMusicPlayer():BackgroundMusicPlayer {
			return musicPlayer;
		}
		
	}
}